﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/core/profile/nifm_NetworkProfileBase.h>

#include <nn/util/util_Uuid.h>

namespace nn
{
namespace nifm
{
namespace detail
{

class DummyNetworkProfile : public NetworkProfileBase
{
public:
    DummyNetworkProfile() NN_NOEXCEPT {}
    virtual ~DummyNetworkProfile() NN_NOEXCEPT {}

    explicit DummyNetworkProfile( nn::util::Uuid& id ) NN_NOEXCEPT
        : NetworkProfileBase(id)
    {
    }

    virtual NetworkInterfaceType GetNetworkInterfaceType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return NetworkInterfaceType_Invalid;
    }

    virtual ProfileType GetType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return ProfileType::DummyProfile;
    }
};

}
}
}
