﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/core/networkInterface/nifm_NetworkInterfaceBase.h>
#include <nn/nifm/detail/core/accessPoint/nifm_EthernetAccessPoint.h>

#include <iphlpapi.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class EthernetInterface : public NetworkInterfaceBase
{
    NN_DISALLOW_COPY(EthernetInterface);
    NN_DISALLOW_MOVE(EthernetInterface);

    friend NetworkInterfaceBase;
    friend EthernetAccessPoint;

private:
    bool m_IsInitialized;
    bool m_IsAvailable;
    DWORD m_Index;

    MacAddress m_MacAddress;

    HANDLE m_IpInterfaceChangeNotificationHandle;

    union
    {
        nn::util::TypedStorage<EthernetAccessPoint, sizeof(EthernetAccessPoint), NN_ALIGNOF(EthernetAccessPoint)> m_EthernetAccessPointStorage;
    } m_AccessPointStorage;

public:
    EthernetInterface() NN_NOEXCEPT;

    virtual ~EthernetInterface() NN_NOEXCEPT NN_OVERRIDE;

    nn::Result Initialize() NN_NOEXCEPT;
    nn::Result Initialize( const MacAddress& macAddress ) NN_NOEXCEPT;

    bool IsInitialized() const NN_NOEXCEPT;

    bool IsAvailable() const NN_NOEXCEPT;

    virtual NetworkInterfaceType GetNetworkInterfaceType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return NetworkInterfaceType_Ethernet;
    }

    virtual MacAddress* GetMacAddress( MacAddress* pOutMacAddress ) const NN_NOEXCEPT NN_OVERRIDE;

    // アクセスポイントの一覧を取得
    virtual nn::Result GetLatestAccessPointList(AccessPointListBase* pAccessPointList, nn::TimeSpan timeSpan) NN_NOEXCEPT NN_OVERRIDE;

    virtual bool IsLinkUp() const NN_NOEXCEPT NN_OVERRIDE;

private:
    virtual void* GetAccessPointStoragePointer() NN_NOEXCEPT NN_OVERRIDE
    {
        return &m_AccessPointStorage;
    }
    virtual size_t GetAccessPointStorageSize() NN_NOEXCEPT NN_OVERRIDE
    {
        return sizeof(m_AccessPointStorage);
    }

    nn::Result ConnectImpl(const EthernetAccessPoint& ethernetAccessPoint, const NetworkProfileBase& networkProfile, const AggregatedRequestType& aggregatedRequest) NN_NOEXCEPT;
    nn::Result DisconnectImpl(const EthernetAccessPoint& ethernetAccessPoint) NN_NOEXCEPT;
    nn::Result ReleaseImpl(const EthernetAccessPoint& ethernetAccessPoint) NN_NOEXCEPT;
    void UpdateAccessPoint(EthernetAccessPoint* pInOutEthernetAccessPoint, const NetworkProfileBase& networkProfile) NN_NOEXCEPT;

private:
    bool IsMediaConnected() const NN_NOEXCEPT;

private:
    static VOID WINAPI IpInterfaceChangeNotificationCallback(PVOID pContext, ::PMIB_IPINTERFACE_ROW pIpInterfaceRow, ::MIB_NOTIFICATION_TYPE notificationType) NN_NOEXCEPT;

    void IpInterfaceChangeNotificationCallbackImpl(::PMIB_IPINTERFACE_ROW pIpInterfaceRow, ::MIB_NOTIFICATION_TYPE notificationType) NN_NOEXCEPT;

    virtual nn::Result PutToSleepImpl() NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result WakeUpImpl() NN_NOEXCEPT NN_OVERRIDE;
};

}
}
}

