﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/core/connectionConfirmation/nifm_HttpClientBase.horizon.h>

namespace nn
{
namespace nifm
{
namespace detail
{

class ConnectionTestClient : public HttpClientBase
{
    NN_DISALLOW_COPY(ConnectionTestClient);
    NN_DISALLOW_MOVE(ConnectionTestClient);

public:
    static const char ConnTestUrl[];

private:
    class HttpHeaderReaderForConnTest : public HttpHeaderReaderBase
    {
    public:
        bool m_IsOrganizationValidated;
        char* m_pLocation;

        HttpHeaderReaderForConnTest() NN_NOEXCEPT;
        virtual ~HttpHeaderReaderForConnTest() NN_NOEXCEPT;
        virtual void Parse(const char* pInLine, size_t size) NN_NOEXCEPT;
        virtual void Clear() NN_NOEXCEPT;
    } m_HttpHeaderReader;

private:
    static size_t ResponseHeaderLineCallbackStatic(char* pInLine, size_t size, size_t nmemb, void* pContext) NN_NOEXCEPT;
    static size_t ResponseBodyWriteCallbackStatic(void* pData, size_t size, size_t nmemb, void* pContext) NN_NOEXCEPT;

    size_t ResponseHeaderLineCallback(char* pInLine, size_t size, size_t nmemb) NN_NOEXCEPT;
    size_t ResponseBodyWriteCallback(void* pData, size_t size, size_t nmemb) NN_NOEXCEPT;

public:
    ConnectionTestClient() NN_NOEXCEPT;
    ~ConnectionTestClient() NN_NOEXCEPT;

    nn::Result ConfirmInternetConnection(const char* pUrl) NN_NOEXCEPT;

    const char* GetRedirectUrlPointer() const NN_NOEXCEPT;
};

}
}
}
