﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/core/connectionConfirmation/nifm_HttpClientBase.horizon.h>
#include <nn/nifm/nifm_TypesNetworkInterface.h>
#include <nn/nifm/nifm_TypesWirelessSetting.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class AuthenticationClient : public HttpClientBase
{
    NN_DISALLOW_COPY(AuthenticationClient);
    NN_DISALLOW_MOVE(AuthenticationClient);

public:
    static const char AuthenticationUrl[];

private:
    class HttpHeaderReaderForAuth : public HttpHeaderReaderBase
    {
    public:
        HttpHeaderReaderForAuth() NN_NOEXCEPT;
        virtual ~HttpHeaderReaderForAuth() NN_NOEXCEPT;
        virtual void Parse(const char* pInLine, size_t size) NN_NOEXCEPT;
        virtual void Clear() NN_NOEXCEPT;
    } m_HttpHeaderReader;


    const HttpResponse* m_pConnTestResponse;

    size_t m_ContentSize;

    bool m_ClientCertificateUsed;

    MacAddress m_MacAddress;
    MacAddress m_Bssid;
    Ssid m_Ssid;

private:
    static size_t ResponseBodyWriteCallbackStatic(void *pData, size_t size, size_t nmemb, void *pContext) NN_NOEXCEPT;
    size_t ResponseBodyWriteCallback(void *pData, size_t size, size_t nmemb) NN_NOEXCEPT;

    static CURLcode CurlSslContextCallbackStatic(CURL* curl, void* sslContext, void* pContext) NN_NOEXCEPT;
    CURLcode CurlSslContextCallback(CURL* curl, void* sslContext, bool isClientCertificateUsed) NN_NOEXCEPT;

    void SetClientCertificateUsed(bool isClientCertificateUsed) NN_NOEXCEPT;
    bool IsClientCertificateUsed() NN_NOEXCEPT;

    nn::Result AddPostData(const char* pKey, const char* pValue, int size) NN_NOEXCEPT;

    nn::Result RetrieveDataFromNasResponse(char* pOutUrl, size_t urlSize) NN_NOEXCEPT;

    nn::Result AuthenticateNas(const char* pUrl) NN_NOEXCEPT;
    nn::Result AuthenticateHotspot(const char* pUrl) NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;

public:
    explicit AuthenticationClient(const HttpResponse* pResponse) NN_NOEXCEPT;
    ~AuthenticationClient() NN_NOEXCEPT;

    // メイン認証処理
    nn::Result Authenticate(const char* pUrl) NN_NOEXCEPT;

    // リクエストパラメータ
    void SetMacAddress(const MacAddress& macAddress) NN_NOEXCEPT;
    void SetBssid(const MacAddress& bssid) NN_NOEXCEPT;
    void SetSsid(const Ssid& ssid) NN_NOEXCEPT;

    const char* GetRedirectUrlPointer() NN_NOEXCEPT;
};

}
}
}
