﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/core/accessPoint/nifm_AccessPointBase.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class WirelessInterface;

class NeighborDetectionAccessPoint : public AccessPointBase
{
    friend WirelessInterface;

public:
    explicit NeighborDetectionAccessPoint(WirelessInterface* pWirelessInterface) NN_NOEXCEPT;
    virtual ~NeighborDetectionAccessPoint() NN_NOEXCEPT;

    virtual NetworkType GetNetworkType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return NetworkType_NeighborDetection;
    }

    virtual nn::Result TryExport(AccessPointData* pOutAccessPointData) const NN_NOEXCEPT NN_OVERRIDE
    {
        NN_UNUSED(pOutAccessPointData);

        NN_RESULT_THROW(ResultNeighborDetectConnection());
    }

    virtual AccessPointBase* CopyTo(void* p, size_t size) const NN_NOEXCEPT NN_OVERRIDE;
    virtual size_t GetSize() const NN_NOEXCEPT NN_OVERRIDE;

    virtual bool operator==(const AccessPointBase& rh) const NN_NOEXCEPT NN_OVERRIDE;

private:
    virtual nn::Result ConnectImpl(const NetworkProfileBase& networkProfile, const AggregatedRequestType& aggregatedRequest) const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result DisconnectImpl() const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result ReleaseImpl() const NN_NOEXCEPT NN_OVERRIDE;
    virtual void UpdateAccessPoint(const NetworkProfileBase& networkProfile) NN_NOEXCEPT NN_OVERRIDE;
};

}
}
}
