﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Types.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_Tick.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/nfp/nfp_Types.h>

namespace nn { namespace nfp { namespace server {

class PlayReport
{
public:
    enum AccessInfo
    {
        AccessInfo_Read,
        AccessInfo_WriteApplicationArea,
        AccessInfo_WriteRegisterInfo,
        AccessInfo_DeleteApplicationArea,
        AccessInfo_Format,
    };

    enum DeviceType
    {
        DeviceType_JoyConRight,
        DeviceType_Handheld,
        DeviceType_FullKeyController,
    };

public:
    PlayReport() NN_NOEXCEPT;
    ~PlayReport() NN_NOEXCEPT;
    void Lock() NN_NOEXCEPT;
    void Unlock() NN_NOEXCEPT;
    void SetTagId(const nn::nfc::TagId& tagId) NN_NOEXCEPT;
    void SetModelInfo(const nn::nfp::ModelInfo& modelInfo) NN_NOEXCEPT;
    void SetProcessId(const nn::os::ProcessId& processId) NN_NOEXCEPT;
    void SetAccessInfo(AccessInfo accessInfo) NN_NOEXCEPT;
    void SetNpadId(nn::hid::NpadIdType npadId) NN_NOEXCEPT;
    void Save() NN_NOEXCEPT;

private:
    bool IsSaveEnabled();

private:
    mutable nn::os::MutexType m_Mutex;
    nn::nfc::TagId m_TagId;
    nn::nfp::ModelInfo m_ModelInfo;
    nn::os::ProcessId m_ProcessId;
    AccessInfo m_AccessInfo;
    nn::hid::NpadIdType m_NpadId;
    nn::os::Tick m_LastSavedTick;
    nn::nfc::TagId m_LastSavedTagId;
};

}}}  // namespace nn::nfp::server
