﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/os/os_Thread.h>
#include <nn/os/os_ReaderWriterLock.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/nfp/nfp_DebugTypes.h>
#include <nn/nfp/nfp_PrivateTypes.h>
#include <nn/nfp/nfp_Types.h>
#include <nn/nfp/nfp_Result.h>
#include <nn/nfp/nfp_PrivateResult.h>
#include <nn/nfp/server/nfp_Device.h>

namespace nn { namespace nfc { namespace server {
    class Manager;
}}}

namespace nn { namespace nfp { namespace server {

    class Manager
    {
    public:
        explicit Manager(nn::nfc::server::Manager* manager) NN_NOEXCEPT;
        ~Manager() NN_NOEXCEPT;
        nn::Result Mount(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, ModelType modelType, MountTarget mountTarget) NN_NOEXCEPT;
        nn::Result Unmount(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result OpenApplicationArea(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, nn::Bit32 accessId) NN_NOEXCEPT;
        nn::Result GetApplicationArea(void* pOutBuffer, size_t* pOutSize, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, size_t bufferSize) NN_NOEXCEPT;
        nn::Result SetApplicationArea(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const void* pData, size_t dataSize) NN_NOEXCEPT;
        nn::Result RecreateApplicationArea(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
        nn::Result Flush(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result Restore(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result CreateApplicationArea(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
        nn::Result GetRegisterInfo(nn::nfp::RegisterInfo* pOutRegisterInfo, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result GetCommonInfo(nn::nfp::CommonInfo* pOutCommonInfo, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result GetModelInfo(nn::nfp::ModelInfo* pOutModelInfo, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;

        nn::Result Format(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result GetAdminInfo(nn::nfp::AdminInfo* pOutAdminInfo, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result GetRegisterInfo(nn::nfp::RegisterInfoPrivate* pOutRegisterInfo, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result SetRegisterInfo(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const nn::nfp::RegisterInfoPrivate& regInfo) NN_NOEXCEPT;
        nn::Result DeleteRegisterInfo(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result DeleteApplicationArea(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result ExistsApplicationArea(bool* outValue, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;

        nn::Result GetAll(nn::nfp::NfpData* pOutNfpData, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result SetAll(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const nn::nfp::NfpData& nfpData) NN_NOEXCEPT;
        nn::Result FlushDebug(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result BreakTag(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, BreakType breakType) NN_NOEXCEPT;
        nn::Result ReadBackupData(void* pOutBuffer, size_t* pOutSize, nn::nfc::server::core::Service* service, size_t bufferSize) NN_NOEXCEPT;
        nn::Result WriteBackupData(nn::nfc::server::core::Service* service, const void* pData, size_t dataSize) NN_NOEXCEPT;
        nn::Result WriteNtf(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const void* pData, size_t dataSize, NtfWriteType ntfWriteType) NN_NOEXCEPT;
        static size_t GetApplicationAreaSize() NN_NOEXCEPT;

    private:
        Manager() NN_NOEXCEPT;

    private:
        nn::nfc::server::Manager* m_Manager;
    };

}}}  // namespace nn::nfp::server
