﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/os/os_Thread.h>
#include <nn/os/os_ReaderWriterLock.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/nfc/nfc_Result.h>
#include <nn/nfc/nfc_PrivateResult.h>
#include <nn/nfc/nfc_NfpResult.internal.h>
#include <nn/nfc/pt/server/nfc_PtDevice.h>

namespace nn { namespace nfc { namespace server {
    class Manager;
}}}

namespace nn { namespace nfc { namespace pt { namespace server {

    class Manager
    {
    public:
        explicit Manager(nn::nfc::server::Manager* manager) NN_NOEXCEPT;
        ~Manager() NN_NOEXCEPT;
        nn::Result SendCommand(void* pOutBuffer, size_t* pOutSize, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const void* pData, size_t dataSize, size_t bufferSize, nn::TimeSpan timeout) NN_NOEXCEPT;
        nn::Result KeepSession(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        nn::Result ReleaseSession(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;

    private:
        Manager() NN_NOEXCEPT;

    private:
        nn::nfc::server::Manager* m_Manager;
    };

}}}}  // namespace nn::nfc::pt::server
