﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/os/os_Thread.h>
#include <nn/os/os_ReaderWriterLock.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/nfc/nfc_MifareTypes.h>
#include <nn/nfc/mifare/server/nfc_MifareDevice.h>

namespace nn { namespace nfc { namespace server {
    class Manager;
}}}

namespace nn { namespace nfc { namespace mifare { namespace server {

    class Manager
    {
    public:
        explicit Manager(nn::nfc::server::Manager* manager) NN_NOEXCEPT;
        ~Manager() NN_NOEXCEPT;
        nn::Result Read(nn::nfc::MifareReadBlockData* pOutBlockData, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const nn::nfc::MifareReadBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT;
        nn::Result Write(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const nn::nfc::MifareWriteBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT;

    private:
        Manager() NN_NOEXCEPT;

    private:
        nn::nfc::server::Manager* m_Manager;
    };

}}}}  // namespace nn::nfc::mifare::server
