﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/ipc/news_INewsDataService.sfdl.h>
#include <nn/news/detail/service/news_Capability.h>
#include <nn/news/detail/service/news_ServiceMemoryManager.h>
#include <nn/fs.h>

namespace nn { namespace news { namespace detail { namespace service {

/*!
    @brief      データサービスセッションです。
*/
class NewsDataService
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  capability  ケイパビリティ。
    */
    explicit NewsDataService(const Capability& capability) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~NewsDataService() NN_NOEXCEPT;

public:
    // INewsDataService
    nn::Result Open(const nn::sf::InArray<char>& name) NN_NOEXCEPT;
    nn::Result OpenWithNewsRecord(const nn::news::NewsRecord& record) NN_NOEXCEPT;
    nn::Result OpenWithNewsRecordV1(const nn::news::NewsRecordV1& record) NN_NOEXCEPT;
    nn::Result Read(nn::sf::Out<std::uint64_t> outSize, std::int64_t offset, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result GetSize(nn::sf::Out<std::int64_t> outSize) NN_NOEXCEPT;

private:
    //
    Capability m_Capability;
    //
    nn::fs::FileHandle m_Handle;
    bool m_IsOpened;
};

NN_STATIC_ASSERT(sizeof (NewsDataService) <= detail::service::ServiceMemoryManager::NewsDataServiceSize);

}}}}
