﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace msgpack {

/*!
    @brief      ファイルの入力ストリームです。
*/
class FileInputStream : public nne::nlib::InputStream
{
public:
    /*!
        @brief      コンストラクタです。
    */
    FileInputStream() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    virtual ~FileInputStream() NN_NOEXCEPT;

    /*!
        @brief      ワークバッファを設定します。

        @param[in]  buffer  バッファ。
        @param[in]  size    バッファサイズ。

        @details
                    バッファに nullptr を指定することで、以降バッファが利用されないことを保証できます。
    */
    void SetBuffer(void* buffer, size_t size) NN_NOEXCEPT;

    /*!
        @brief      ファイルを開きます。

        @param[in]  path    パス。

        @return     処理結果。

        @pre
            - path != nullptr
    */
    nn::Result Open(const char* path) NN_NOEXCEPT;

    /*!
        @brief      ファイルを閉じます。
    */
    void Close() NN_NOEXCEPT;

private:
    //
    nn::fs::FileHandle m_Handle;
    bool m_IsOpened;
    bool m_IsSuspended;
    //
    const char* m_Path;
    //
    int64_t m_Offset;
    //
    void* m_Buffer;
    size_t m_BufferSize;

private:
    // InputStream
    virtual size_t FillBuffer_(void* p, size_t nbytes) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool Close_() NN_NOEXCEPT NN_OVERRIDE;
    virtual void* GetWorkBuffer_(size_t* nbytes) NN_NOEXCEPT NN_OVERRIDE;
    virtual size_t Skip_(size_t nbytes) NN_NOEXCEPT NN_OVERRIDE;
};

}}}}}
