﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>
#include <nn/news/detail/service/core/news_NewsDatabase.h>
#include <nn/news/detail/service/msgpack/news_MsgpackEventHandler.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      ニュースメタデータのリーダーです。
*/
class NewsMetadataReader : public detail::service::msgpack::MsgpackEventHandler
{
private:
    NN_DISALLOW_COPY(NewsMetadataReader);
    NN_DISALLOW_MOVE(NewsMetadataReader);

public:
    /*!
        @brief      ニュースのパース結果です。
    */
    struct NewsParseBits
    {
        Bit64 formatVersion : 1;
        Bit64 semanticsVersion : 1;
        Bit64 newsId : 1;
        Bit64 publishedAt : 1;
        Bit64 expireAt : 1;
        Bit64 pickupLimit : 1;
        Bit64 priority : 1;
        Bit64 deletionPriority : 1;
        Bit64 ageLimit : 1;
        Bit64 applicationIds : 1;
        Bit64 topicId : 1;
        Bit64 surprise : 1;
        Bit64 bashotorya : 1;
        Bit64 essentialPickupPickupLimit : 1;
        Bit64 essentialPickupPriorityAfter : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    NewsMetadataReader() NN_NOEXCEPT;

    /*!
        @brief      ニュースメタデータを読み込みます。

        @param[in]  outRecord   レコード。
        @param[in]  stream      入力ストリーム。
        @param[in]  isLocal     ローカルインポートかどうか。

        @return     処理結果。

        @pre
            - outParam != nullptr
    */
    nn::Result Read(NewsDatabase::InsertRecord* outRecord, nne::nlib::InputStream& stream, bool isLocal) NN_NOEXCEPT;

private:
    //
    struct EssentialPickupInfo
    {
        nn::time::PosixTime pickupLimit;
        int32_t priorityAfter;
    };

private:
    //
    detail::service::msgpack::JsonPath m_JsonPath;
    //
    NewsParseBits m_Bits;
    //
    uint64_t m_RawNewsId;
    //
    NewsVersion m_Version;
    NewsDatabase::InsertRecord* m_Record;
    //
    EssentialPickupInfo m_EssentialPickupInfo;

private:
    // MsgpackEventHandler
    virtual bool OnStartArray(const detail::service::msgpack::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndArray(const detail::service::msgpack::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnBoolean(const detail::service::msgpack::JsonPath& jsonPath, bool value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::msgpack::JsonPath& jsonPath, const detail::service::msgpack::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::msgpack::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;
};

}}}}}
