﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      ニュースのダウンロードモジュールです。
*/
class NewsDownloader
{
public:
    /*!
        @brief      ニュースをダウンロードします。

        @param[in]  topicId         トピック ID。
        @param[in]  eTag            配信リストの ETag。
        @param[in]  connection      ネットワーク接続要求オブジェクト。
        @param[in]  bgtcTask        BGTC タスク。
        @param[in]  pCancelEvent    キャンセルイベント。

        @return     処理結果。

        @details
                    指定したトピックの配信リストをダウンロードし、未受信のニュースデータをダウンロードします。@n
                    ニュースデータを 1 つダウンロードする度、ストレージに書き込みます。
    */
    static nn::Result Download(const TopicId& topicId, const ETag& eTag,
        nn::nifm::NetworkConnection& connection, nn::bgtc::Task& bgtcTask, nn::os::Event* pCancelEvent = nullptr) NN_NOEXCEPT;

    /*!
        @brief      ニュースをダウンロードします。

        @param[in]  url             配信リスト URL。
        @param[in]  connection      ネットワーク接続要求オブジェクト。
        @param[in]  bgtcTask        BGTC タスク。
        @param[in]  pCancelEvent    キャンセルイベント。

        @return     処理結果。

        @details
                    配信リストの URL を直接指定し、未受信のニュースデータをダウンロードします。@n
                    ニュースデータを 1 つダウンロードする度、ストレージに書き込みます。
    */
    static nn::Result Download(const Url& url,
        nn::nifm::NetworkConnection& connection, nn::bgtc::Task& bgtcTask, nn::os::Event* pCancelEvent = nullptr) NN_NOEXCEPT;
};

}}}}}
