﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      アカウントライブラリのラッパーモジュールです。
*/
class Account
{
public:
    /*!
        @brief      ニンテンドーアカウントの居住国です。
    */
    struct Country
    {
        char value[4];
    };

public:
    /*!
        @brief      本体に有効なニンテンドーアカウントが 1 つ以上紐付いているかどうかを確認します。

        @return     有効なニンテンドーアカウントが 1 つ以上紐付いているかどうか。
    */
    static bool IsAvailableNintendoAccountLinked() NN_NOEXCEPT;

    /*!
        @brief      本体に紐付くニンテンドーアカウントの居住国リストを取得します。

        @param[out] outCount        取得した居住国の数。
        @param[out] outCountries    居住国リスト。
        @param[in]  count           居住国リストの要素数。

        @pre
            - outCount ! nullptr
            - outCodes ! nullptr
            - count > 0
    */
    static void GetCountryList(int* outCount, Country* outCountries, int count) NN_NOEXCEPT;
};

}}}}}
