﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/news_TypesAdmin.h>

namespace nn { namespace news { namespace detail {

/*!
    @brief      SQLITE が利用するヒープのサイズです。
*/
const size_t SqliteHeapSize = 512 * 1024;

/*!
    @brief      ETag です。
*/
struct ETag
{
    char value[40];
};

/*!
    @brief      リビジョンのハッシュ値です。
*/
struct RevisionHash
{
    Bit8 value[8];
};

/*!
    @brief      配信データのダウンロード URL です。
*/
struct Url
{
    char value[256];
};

/*!
    @brief      ニュースのバージョンです。
*/
struct NewsVersion
{
    int8_t format;
    int8_t semantics;
};

}}}
