﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mii/detail/service/mii_ServiceCommon.h>
#include <nn/mii/detail/service/mii_IDatabaseService.sfdl.h>

#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn
{
namespace mii
{
namespace detail
{

class ServiceProvider;
class IDatabaseService;

class StaticServiceInterface
{
private:
    ServiceProvider* m_pServiceProvider;
    nn::sf::ExpHeapAllocator* m_pExpHeapAllocator;

    const bool m_IsEditor;

public:
    StaticServiceInterface(
        ServiceProvider* pServiceProvider,
        nn::sf::ExpHeapAllocator* pExpHeapAllocator,
        bool isEditor
    ) NN_NOEXCEPT;

    ~StaticServiceInterface() NN_NOEXCEPT;

    nn::Result GetDatabaseService(nn::sf::Out<nn::sf::SharedPointer<IDatabaseService>> outIDatabaseService, int specialMiiKeyCode) NN_NOEXCEPT;
};

}
}
}
