﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリの定数・列挙体の定義
 */

#pragma once

namespace nn { namespace lbl {

/**
 * @brief 写像の係数
 */
const int CoefficentCountMax = 3;
struct MappingCoefficient
{
    float coefficient[CoefficentCountMax];
};

/**
 * @brief 自動輝度調整の明るさの遷移方向
 */
enum BrightnessChangeDirection
{
    BrightnessChangeDirection_DarkToBright, //!< 暗い状態から明るい状態への遷移方向を表します。
    BrightnessChangeDirection_BrightToDark  //!< 明るい状態から暗い状態への遷移方向を表します。
};

/**
 * @brief バックライトの点灯/消灯の状態
 */
enum BacklightSwitchStatus
{
    BacklightSwitchStatus_OffWithStability,     //!< 消灯の状態を表します。
    BacklightSwitchStatus_OnWithStability,      //!< 点灯の状態を表します。
    BacklightSwitchStatus_OffInTransitionToOn,  //!< 消灯の状態ですが、点灯の状態へ遷移中であることを表します。
    BacklightSwitchStatus_OnInTransitionToOff   //!< 点灯の状態ですが、消灯の状態へ遷移中であることを表します。
};

} // lbl
} // nn


