﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリの基本的な輝度制御機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace lbl {

/**
 * @brief 現在の輝度設定値をLCDバックライトに適用します。
 *
 * @pre         初期化されている必要があります。
 * @post        LCDバックライトの明るさが変わります。
 * @details     現在の輝度設定値をLCDバックライトに適用します。
 */
void ApplyCurrentBrightnessSettingToBacklight() NN_NOEXCEPT;

/**
 * @brief LCDバックライトに適用された輝度設定値を取得します。
 *
 * @return      LCDバックライトに適用された輝度設定値を返します。
 * @pre         初期化されている必要があります。
 * @details     LCDバックライトに適用された輝度設定値を取得します。
 */
float GetBrightnessSettingAppliedToBacklight() NN_NOEXCEPT;

} // lbl
} // nn


