﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   認証アプレット起動に関する非公開ヘッダ
 */

#pragma once

#include <nn/nn_Result.h>
#include <nn/applet/applet_Storage.h>
#include <nn/la/la_AuthParentalAuthenticationArg.h>

/**
 * @internal
 *
 * @namespace nn::la::auth
 * @brief 認証アプレット名前空間。
 */

namespace nn { namespace la { namespace auth {

/**
 * @brief アプレットの結果（成功orキャンセル）を格納するための構造体
 */
struct ReturnArg
{
    nn::Result result;
};

/**
 * @internal
 *
 * @brief auth(LA) を起動し、保護者認証を行います
 *
 * @details
 */
nn::Result ShowParentalAuthentication( bool isTemporary ) NN_NOEXCEPT;

/**
 * @internal
 *
 * @brief auth(LA) を起動し、保護者認証を行います
 *
 * @details
 */
nn::Result ShowParentalAuthentication( const ParentalAuthenticationArg& arg ) NN_NOEXCEPT;

/**
* @internal
*
* @brief auth(LA) を起動し、保護者認証用パスコードを登録します
*
* @details
*/
nn::Result RegisterParentalPasscode() NN_NOEXCEPT;

/**
* @internal
*
* @brief auth(LA) を起動し、保護者認証用パスコードを変更します
*
* @details
*/
nn::Result ChangeParentalPasscode() NN_NOEXCEPT;

/**
* @brief コンテキストスタックに残されたアプレットの実行結果を取得します。ライブラリアプレット向けです。
*
* @param[out] pOut 結果の格納先
* @param[in] nn::applet::TryPopFromOutChannel()で取り出したストレージハンドル
*
* @details
* - 他のライブラリアプレットを呼び出すために Program Winding したライブラリアプレットが、Unwind した後に呼び出し結果を取得するための機能です。
* - handleから値を取り出すだけでリリース等は行いません。
*/
Result GetResultFromContextStack( ReturnArg* pOut, nn::applet::StorageHandle handle ) NN_NOEXCEPT;

}}} // namespace nn::la::auth

