﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ライブラリアプレットからの応答の受け取りをおこなうクラスの非公開ヘッダ
 */

#pragma once

#include <nn/la/la_AppletToNifmArguments.h>

#include <nn/applet/applet.h>

namespace nn { namespace la {

/**
 * @brief   ライブラリアプレットから NIFM への応答の受け取りをおこなうクラスです。
 *          NIFM の Shim レイヤで利用されます。
 */
class AppletToNifmArgumentsReader
{
private:
    bool m_IsInitialized;

    NN_DETAIL_LA_CURRENT_APPLETTONIFM_ARGUMENTS_DATA_TYPE m_AppletToNifmArgumentsData;

private:
    bool ReadNetConnectReturnParam(nn::applet::StorageHandle storageHandle) NN_NOEXCEPT;

public:
    /**
     * @brief   コンストラクタです。
     *
     * @details
     */
    AppletToNifmArgumentsReader() NN_NOEXCEPT;

    /**
     * @brief   デストラクタです。
     *
     * @details
     */
    ~AppletToNifmArgumentsReader() NN_NOEXCEPT;


    /**
     * @brief   出力チャンネルから応答の pop を試みます。
     *
     * @param[in]   appletHandle  ライブラリアプレットハンドル
     *
     * @return  取得に成功すれば true が、失敗すれば false が返ります。
     *
     * @details
     *  内部で ReadFromStorage() を呼び出します。
     *  取得に失敗した場合でも、出力チャンネルの状態に副作用を与えることがあります。
     */
    bool TryPopFromOutChannel(nn::applet::LibraryAppletHandle appletHandle) NN_NOEXCEPT;

    /**
     * @brief   指定されたストレージから応答を読み込みます
     *
     * @param[in]   storageHandle  ストレージハンドル
     *
     * @return  取得に成功すれば true が、失敗すれば false が返ります。
     *
     * @details
     *  TryPopFromOutChannel() 内部で呼び出されます。
     */
    bool ReadFromStorage(const nn::applet::StorageHandle storageHandle) NN_NOEXCEPT;

    /**
     * @brief   アプレットによる疎通確認の結果を取得します。
     *
     * @return  アプレットによる疎通確認の結果が返ります。
     *
     * @pre     事前に TryPopFromInChannel() によって入力チャンネルから共通引数を pop する必要があります。
     *
     * @details
     */
    Result GetResult() NN_NOEXCEPT;
};

}} // namespace nn::la

