﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/jit/jit_CommonTypes.h>

namespace nn { namespace jit { namespace plugin {

/**
    @brief 開発用機能を有効にします。

    @pre 開発環境である
    @pre ConfigurePlugin() の呼び出し内である
*/
void EnableDevelopmentFunctions() NN_NOEXCEPT;

/**
    @brief コード領域用のメモリのセキュリティを指定します。

    @param[in] mode セキュリティモードを指定します。

    @pre EnableDevelopmentFunctions() が呼ばれている
    @pre ConfigurePlugin() の呼び出し内である
*/
void SetCodeMemorySecurityForDevelopment(MemorySecurityMode mode) NN_NOEXCEPT;

/**
    @brief ワークメモリのセキュリティを指定します。

    @param[in] mode セキュリティモードを指定します。

    @pre EnableDevelopmentFunctions() が呼ばれている
    @pre ConfigurePlugin() の呼び出し内である
*/
void SetWorkMemorySecurityForDevelopment(MemorySecurityMode mode) NN_NOEXCEPT;

}}}
