﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/i2c/i2c_ISession.sfdl.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_DeviceCode.h>
#include <nn/nn_Result.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace i2c { // NOLINT(whitespace/braces)

class IManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSessionForDev, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::std::int32_t busIdx, ::nn::Bit16 slaveAddress, ::std::int32_t addressingMode, ::std::int32_t speedMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::std::int32_t device))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasDevice, (::nn::sf::Out<bool> hasDevice, ::std::int32_t device))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasDeviceForDev, (::nn::sf::Out<bool> hasDevice, ::std::int32_t busIdx, ::nn::Bit16 slaveAddress, ::std::int32_t addressingMode, ::std::int32_t speedMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSession2, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::nn::detail::DeviceCodeType name))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManager)

        ::nn::Result OpenSessionForDev(::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::std::int32_t busIdx, ::nn::Bit16 slaveAddress, ::std::int32_t addressingMode, ::std::int32_t speedMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSessionForDev, (outSession, busIdx, slaveAddress, addressingMode, speedMode));
        }

        ::nn::Result OpenSession(::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::std::int32_t device) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSession, (outSession, device));
        }

        ::nn::Result HasDevice(::nn::sf::Out<bool> hasDevice, ::std::int32_t device) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasDevice, (hasDevice, device));
        }

        ::nn::Result HasDeviceForDev(::nn::sf::Out<bool> hasDevice, ::std::int32_t busIdx, ::nn::Bit16 slaveAddress, ::std::int32_t addressingMode, ::std::int32_t speedMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasDeviceForDev, (hasDevice, busIdx, slaveAddress, addressingMode, speedMode));
        }

        ::nn::Result OpenSession2(::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::nn::detail::DeviceCodeType name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSession2, (outSession, name));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManager
    {
    public:
        nn::Result OpenSessionForDev(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT;
        nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, std::int32_t device) NN_NOEXCEPT;
        nn::Result HasDevice(nn::sf::Out<bool> hasDevice, std::int32_t device) NN_NOEXCEPT;
        nn::Result HasDeviceForDev(nn::sf::Out<bool> hasDevice, std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT;
        nn::Result OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, nn::detail::DeviceCodeType name) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenSessionForDev(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT;
    nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, std::int32_t device) NN_NOEXCEPT;
    nn::Result HasDevice(nn::sf::Out<bool> hasDevice, std::int32_t device) NN_NOEXCEPT;
    nn::Result HasDeviceForDev(nn::sf::Out<bool> hasDevice, std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT;
    nn::Result OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, nn::detail::DeviceCodeType name) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::i2c::IManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSessionForDev, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::std::int32_t busIdx, ::nn::Bit16 slaveAddress, ::std::int32_t addressingMode, ::std::int32_t speedMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSessionForDev, (outSession, busIdx, slaveAddress, addressingMode, speedMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::std::int32_t device))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSession, (outSession, device));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasDevice, (::nn::sf::Out<bool> hasDevice, ::std::int32_t device))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasDevice, (hasDevice, device));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasDeviceForDev, (::nn::sf::Out<bool> hasDevice, ::std::int32_t busIdx, ::nn::Bit16 slaveAddress, ::std::int32_t addressingMode, ::std::int32_t speedMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasDeviceForDev, (hasDevice, busIdx, slaveAddress, addressingMode, speedMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSession2, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::nn::detail::DeviceCodeType name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSession2, (outSession, name));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::i2c::IManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::i2c::IManager))

    // nn::Result OpenSessionForDev(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSessionForDev)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outSession, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outSession))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slaveAddress, (::nn::Bit16), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(busIdx, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(addressingMode, (::std::int32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(speedMode, (::std::int32_t), 12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (slaveAddress, busIdx, addressingMode, speedMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSession), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(busIdx), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slaveAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(addressingMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(speedMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSessionForDev)

    // nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, std::int32_t device) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outSession, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outSession))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(device, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (device))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSession), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(device)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSession)

    // nn::Result HasDevice(nn::sf::Out<bool> hasDevice, std::int32_t device) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(device, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (device))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(hasDevice, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (hasDevice))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hasDevice), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(device)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasDevice)

    // nn::Result HasDeviceForDev(nn::sf::Out<bool> hasDevice, std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasDeviceForDev)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slaveAddress, (::nn::Bit16), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(busIdx, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(addressingMode, (::std::int32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(speedMode, (::std::int32_t), 12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (slaveAddress, busIdx, addressingMode, speedMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(hasDevice, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (hasDevice))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hasDevice), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(busIdx), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slaveAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(addressingMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(speedMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasDeviceForDev)

    // nn::Result OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, nn::detail::DeviceCodeType name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSession2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outSession, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outSession))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(name, (::nn::detail::DeviceCodeType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (name))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSession), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSession2)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::detail::DeviceCodeType), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::i2c::IManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::i2c::IManager))

    // nn::Result OpenSessionForDev(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSessionForDev, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::std::int32_t busIdx, ::nn::Bit16 slaveAddress, ::std::int32_t addressingMode, ::std::int32_t speedMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSessionForDev)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(busIdx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slaveAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(addressingMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(speedMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSessionForDev)
    }

    // nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, std::int32_t device) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::std::int32_t device))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(device)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSession)
    }

    // nn::Result HasDevice(nn::sf::Out<bool> hasDevice, std::int32_t device) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasDevice, (::nn::sf::Out<bool> hasDevice, ::std::int32_t device))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hasDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(device)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasDevice)
    }

    // nn::Result HasDeviceForDev(nn::sf::Out<bool> hasDevice, std::int32_t busIdx, nn::Bit16 slaveAddress, std::int32_t addressingMode, std::int32_t speedMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasDeviceForDev, (::nn::sf::Out<bool> hasDevice, ::std::int32_t busIdx, ::nn::Bit16 slaveAddress, ::std::int32_t addressingMode, ::std::int32_t speedMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasDeviceForDev)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hasDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(busIdx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slaveAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(addressingMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(speedMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasDeviceForDev)
    }

    // nn::Result OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nn::i2c::ISession>> outSession, nn::detail::DeviceCodeType name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSession2, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::i2c::ISession>> outSession, ::nn::detail::DeviceCodeType name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSession2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSession2)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::i2c::IManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::i2c::IManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSessionForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::i2c::ISession>), outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSessionForDev)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outSession),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(busIdx),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slaveAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(addressingMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(speedMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outSession, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::i2c::ISession>), outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outSession),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(device)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outSession, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(hasDevice),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(device)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasDeviceForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasDeviceForDev)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(hasDevice),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(busIdx),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slaveAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(addressingMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(speedMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSession2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::i2c::ISession>), outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSession2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outSession),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outSession, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSessionForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasDeviceForDev)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSession2)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::i2c::IManager))
