﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{
namespace i2c{

/**
* @brief デバイス識別子 I2cDevice の定義
*
* @details I2Cドライバライブラリがサポートする I2cDevice の一覧です。
*/
enum I2cDevice
{
    I2cDevice_ClassicController,  //!< Debug pad
    I2cDevice_Tmp451,             //!< Thermal sensor
    I2cDevice_Alc5639,            //!< Audio codec
    I2cDevice_Max77620Pmic        //!< Power management unit - Pmic
};

} //i2c
} //nn
