﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/http/http_ResponseImpl.h>

namespace nn
{
namespace http
{

class DestinationBuffer;
class Progress;

/**
 * @brief   HTTP 応答を表すクラスです

 * @details
 *  このクラスを介して HTTP 応答の解析や受信を行います。
 */
class Response : public ResponseImpl
{
    NN_DISALLOW_COPY(Response);
    NN_DISALLOW_MOVE(Response);
public:
    Response();
    Result ReadBody(size_t *outValue, void *pBuffer, size_t size);
    Result ReadBody(size_t *outValue, void *pBuffer, size_t size, os::Event* pCancelEvent);
    void SetProgressTarget(Progress* pProgress);

protected:
    virtual bool OnFillBuffer(void* pSource, size_t size);
    virtual void OnTransfer(curl_off_t dlTotal, curl_off_t dlNow, curl_off_t ulTotal, curl_off_t ulNow);
    void NotifyBufferFull();

private:
    os::Mutex m_mutexRead;

    DestinationBuffer* m_pDestinationBuffer;
    Progress* m_pProgress;
    size_t m_sizeCopied;
    os::Event* m_pCancelEvent;
};

}
}
