﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os.h>

namespace nn
{
namespace http
{

class Progress
{
public:
    Progress();

    int8_t CalculateProgressPercent() const;
    TimeSpan CalculateEstimatedArraivalTime() const;
    TimeSpan CalculateElapsedTime() const;
    uint32_t GetLastTroughput() const;
    uint32_t CalculateAverageTroughput() const;
    uint64_t GetTransferredBytes() const;

    void PrintProgressBar();
    void Update(uint64_t bytesTransferred, uint64_t bytesTotal);

private:
    uint64_t m_bytesTransferredCurrent;
    uint64_t m_bytesTransferredLast;
    uint64_t m_bytesTotal;
    uint32_t m_bytesLastThroughput;

    os::Tick m_tickStart;
    os::Tick m_tickLast;
    os::Tick m_tickEnd;
};




}
}
