﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/ssl.h>

// TODO
#include <curl/curl.h>

namespace nn
{
namespace http
{
class Request;

/**
 * @brief   複数の HTTP 接続を取りまとめてプールするためのクラスです
 *
 * @details
 *
 *
 *
 *
 */
class ConnectionBroker
{
    NN_DISALLOW_COPY(ConnectionBroker);
    NN_DISALLOW_MOVE(ConnectionBroker);
public:
    static const size_t DefaultSocketBufferSize = 1024 * 8;

    ConnectionBroker();
    ~ConnectionBroker();

    Result Initialize();
    void Finalize();

    void SetMaxTotalConnections(int maxConnections);
    void SetEnableClientCert(bool bEnable);
    void SetProxy(const char* pHostname, uint16_t port);
    void SetProxyAuthentication(const char* pUsername, const char* pPassword);
    void SetNoProxyHostsPointer(const char* pHostnames);
    void SetVerbose(bool bVerbose);
    void SetSkipSslVerificationForDebug(bool bSkip);
    void SetSocketBufferSize(size_t sizeSend, size_t sizeReceive);

    Result CurlWait(const TimeSpan& timeout);
    Result CurlPerform(int& countStillRunning);
    Result PsuedoWaitCondition(nn::os::Mutex& mutex, nn::os::ConditionVariable& cond, os::Event* pCancelEvent = nullptr);

    inline size_t GetSocketSendBufferSize() const
    {
        return m_nBufferSizeSend;
    }
    inline size_t GetSocketReceiveBufferSize() const
    {
        return m_nBufferSizeReceive;
    }

    static const long MaxConnects      = 2;

//protected:
    Result CurlAddEasyHandleToMulti(CURL* pCurlHandle);
    void CurlRemoveEasyHandleFromMulti(CURL * pCurlHandle);
    Result CurlPauseEasyHandle(CURL * pCurlHandle, int action);

    void ApplyDefaultOptions(Request& req);

    static CURLcode CurlSslCtxFunction(CURL* pCurlHandle, void* pSslContext, void* pUserData);
    static curl_socket_t CurlOpenSocketFunction(void *pUserData, curlsocktype purpose, struct curl_sockaddr *address);
    static int CurlSocketOptionFunction(void* pUserData, curl_socket_t curlfd, curlsocktype purpose);
    static int CurlDebugFunction(CURL* pCurlHandle, curl_infotype type, char* pData, size_t size, void* pUserData);

protected:
    virtual Result OnSslContextNeeded(CURL * pCurlHandle, ssl::Context & context);

private:
    Result CommunicateThreadProcedure();
    void ProcessCurlMessages();
    void HandleCurlMessage(CURLMsg& message);

    os::Mutex m_mutexCurl;
    os::Mutex m_mutexPesudoThread;
    os::Event m_eventPesudoThreadLeave;
    CURLM* m_CurlMultiHandle;
    const char* m_pNoProxyHosts;
    char m_ProxyHostname[64];
    char m_ProxyUsername[32];
    char m_ProxyPassword[32];

    uint16_t m_ProxyPort;
    uint32_t m_nBufferSizeSend;
    uint32_t m_nBufferSizeReceive;

    bool m_bEnableClientCert;
    bool m_bEnableManualProxy;
    bool m_bSkipSslVerificationForDebug;
    bool m_bVerbose;
};


}
}
