﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      http モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_HTTP_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(http, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(http, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(http, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(http, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTTP_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(http, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(http, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(http, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(http, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTTP_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(http, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(http, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(http, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(http, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTTP_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(http, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(http, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(http, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(http, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTTP_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(http, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(http, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(http, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_HTTP_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(http, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_HTTP_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(http, Trace, 0, format, args)
#define NN_DETAIL_HTTP_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(http, Trace, 1, format, args)
#define NN_DETAIL_HTTP_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(http, Trace, 2, format, args)
#define NN_DETAIL_HTTP_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(http, Trace, 3, format, args)

#define NN_DETAIL_HTTP_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(http, Info, 0, format, args)
#define NN_DETAIL_HTTP_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(http, Info, 1, format, args)
#define NN_DETAIL_HTTP_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(http, Info, 2, format, args)
#define NN_DETAIL_HTTP_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(http, Info, 3, format, args)

#define NN_DETAIL_HTTP_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(http, Warn, 0, format, args)
#define NN_DETAIL_HTTP_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(http, Warn, 1, format, args)
#define NN_DETAIL_HTTP_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(http, Warn, 2, format, args)
#define NN_DETAIL_HTTP_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(http, Warn, 3, format, args)

#define NN_DETAIL_HTTP_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(http, Error, 0, format, args)
#define NN_DETAIL_HTTP_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(http, Error, 1, format, args)
#define NN_DETAIL_HTTP_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(http, Error, 2, format, args)
#define NN_DETAIL_HTTP_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(http, Error, 3, format, args)

#define NN_DETAIL_HTTP_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(http, Fatal, 0, format, args)
#define NN_DETAIL_HTTP_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(http, Fatal, 1, format, args)
#define NN_DETAIL_HTTP_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(http, Fatal, 2, format, args)
#define NN_DETAIL_HTTP_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(http, Fatal, 3, format, args)

#define NN_DETAIL_HTTP_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(http, Trace, 0, text, length)
#define NN_DETAIL_HTTP_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(http, Trace, 1, text, length)
#define NN_DETAIL_HTTP_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(http, Trace, 2, text, length)
#define NN_DETAIL_HTTP_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(http, Trace, 3, text, length)

#define NN_DETAIL_HTTP_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(http, Info, 0, text, length)
#define NN_DETAIL_HTTP_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(http, Info, 1, text, length)
#define NN_DETAIL_HTTP_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(http, Info, 2, text, length)
#define NN_DETAIL_HTTP_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(http, Info, 3, text, length)

#define NN_DETAIL_HTTP_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(http, Warn, 0, text, length)
#define NN_DETAIL_HTTP_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(http, Warn, 1, text, length)
#define NN_DETAIL_HTTP_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(http, Warn, 2, text, length)
#define NN_DETAIL_HTTP_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(http, Warn, 3, text, length)

#define NN_DETAIL_HTTP_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(http, Error, 0, text, length)
#define NN_DETAIL_HTTP_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(http, Error, 1, text, length)
#define NN_DETAIL_HTTP_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(http, Error, 2, text, length)
#define NN_DETAIL_HTTP_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(http, Error, 3, text, length)

#define NN_DETAIL_HTTP_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(http, Fatal, 0, text, length)
#define NN_DETAIL_HTTP_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(http, Fatal, 1, text, length)
#define NN_DETAIL_HTTP_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(http, Fatal, 2, text, length)
#define NN_DETAIL_HTTP_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(http, Fatal, 3, text, length)
