﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ホスト・ターゲット通信の HIPC サーバに関する公開ヘッダファイル
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/sf/sf_ShimLibraryUtility.h>

#include <nn/htclow/detail/htclow_IUserServiceObject.h>
#include <nn/htclow/detail/htclow_IDebugServiceObject.h>

namespace nn { namespace htclow { namespace server {

void Initialize() NN_NOEXCEPT;

nn::sf::SharedPointer<detail::IUserServiceObject> GetUserServiceObject() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IDebugServiceObject> GetDebugServiceObject() NN_NOEXCEPT;

void RegisterUserHipcServer() NN_NOEXCEPT;
void RegisterDebugHipcServer() NN_NOEXCEPT;

void StartUserHipcServer() NN_NOEXCEPT;
void StartDebugHipcServer() NN_NOEXCEPT;

void LoopUserHipcServer() NN_NOEXCEPT;
void LoopDebugHipcServer() NN_NOEXCEPT;

}}}
