﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_MathTypes.h>

namespace nn { namespace hid { namespace detail {

/**
  * brief      色情報を定義した構造体
  */
struct DeviceColor
{
    union
    {
        nn::util::Color4u8Type color[4];
        struct
        {
            nn::util::Color4u8Type main;
            nn::util::Color4u8Type sub;
            nn::util::Color4u8Type leftGrip;
            nn::util::Color4u8Type rightGrip;
        } fullkey;
    };
};

const DeviceColor ColorJoyConDefault =
{
    {
        {
            { { 130, 130, 130, 255 } },
            { { 15, 15, 15, 255 } },
            { { 0, 0, 0, 0 } },
            { { 0, 0, 0, 0 } },
        }
    }
};

const DeviceColor ColorSwitchProControllerDefault =
{
    {
        {
            { { 45, 45, 45, 255 } },
            { { 230, 230, 230, 255 } },
            { { 70, 70, 70, 255 } },
            { { 70, 70, 70, 255 } },
        }
    }
};

const DeviceColor ColorSwitchProControllerBlitz =
{
    {
        {
            { { 45, 45, 45, 255 } },
            { { 230, 230, 230, 255 } },
            { { 30, 220, 0, 255 }  },
            { { 255, 50, 120, 255 } },
        }
    }
};

const DeviceColor ColorSwitchProControllerBigfolk2 =
{
    {
        {
            { { 45, 45, 45, 255 } },
            { { 230, 230, 230, 255 } },
            { { 220, 60, 100, 255 } },
            { { 220, 60, 100, 255 } },
        }
    }
};
}}} // namespace nn::hid::detail
