﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   GPIO ライブラリの型や定数の定義
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn {
namespace gpio {

/**
* @brief 割り込みモードの列挙型です。
*
* @details 各 GPIO パッドの割り込みモードの設定及び取得の際に使用します。
*/
enum InterruptMode
{
    InterruptMode_LowLevel = 0,   //!< GPIO パッドの入力が L であるときに割り込みが入ります。
    InterruptMode_HighLevel,      //!< GPIO パッドの入力が H であるときに割り込みが入ります。
    InterruptMode_RisingEdge,     //!< GPIO パッドの入力が立ち上がりエッジの変化が起きた際に割り込みが発生します。
    InterruptMode_FallingEdge,    //!< GPIO パッドの入力が立ち下がりエッジの変化が起きた際に割り込みが発生します。
    InterruptMode_AnyEdge,        //!< GPIO パッドの入力変化が起きた際に割り込みが発生します。
};

/**
* @brief GPIO パッドの入出力方向の列挙型です。
*
* @details 各 GPIO パッドの入出力方向の設定及び取得に使用します。
*/
enum Direction
{
    Direction_Input = 0,     //!< 入力方向
    Direction_Output,        //!< 出力方向
};

/**
* @brief GPIO パッドの値の列挙型です。
*
* @details 各 GPIO パッドの値の設定及び取得に使用します。
*/
enum GpioValue
{
    GpioValue_Low = 0,    //!< Low
    GpioValue_High,       //!< High
};

/**
* @brief GPIO パッドの割り込みステータスの列挙型です。
*
* @details 各 GPIO パッドの割り込みステータスの取得に使用します。
*/
enum InterruptStatus
{
    InterruptStatus_Inactive = 0,  //!< 割り込み発生なし
    InterruptStatus_Active,        //!< 割り込み発生
};

// [Gen1] Used for Gen1 only
/**
* @brief 起床要因を表す BitFlag です。
*
* @details 各ビットは GpioPadName の値と対応しています。
*/
typedef nn::util::BitFlagSet<128> WakeBitFlag;

} // gpio
} // nn


