﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace friends {

/*!
    @brief      ライブラリに指定するオプションです。

    @details
                @ref SetOption に指定することができるオプションを定義します。@n
                詳細は、各オプションを参照してください。
*/
enum OptionAdmin
{
    OptionAdmin_Begin = 10000,

    /*!
        @brief      ユーザーアカウントの Open 状態を確認するかどうかを決定するオプションです。

        @details
                    nn::account::Uid を引数にとる関数の事前条件「指定したユーザーアカウントが Open 状態である。」の有効／無効を設定します。@n
                    無効に設定した場合、事前条件判定が無視されるようになります。

                    オプション値には、以下のいずれかを指定してください。

                    - 0：無効
                    - 1：有効

                    デフォルトは有効になっています。
    */
    OptionAdmin_CheckUserStatus = OptionAdmin_Begin + 1
};

}}
