﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_Types.h>
#include <nn/settings/system/settings_News.h>

namespace nn { namespace friends {

/*!
    @name オーバーレイ通知設定
    @{
*/

/*!
    @brief      オーバーレイ通知設定を取得します。

    @param[out] outSettings オーバーレイ通知設定。
    @param[in]  uid         ユーザーアカウント。

    @return     処理結果。

    @pre
        - outSettings != nullptr
        - アカウントライブラリを初期化している。

    @details
                設定が未初期化だった場合、システムの初期値を取得します。
*/
nn::Result GetNotificationSettings(nn::settings::system::AccountNotificationSettings* outSettings,
    const nn::account::Uid& uid) NN_NOEXCEPT;

/*!
    @brief      オーバーレイ通知設定を設定します。

    @param[in]  uid         ユーザーアカウント。
    @param[in]  settings    オーバーレイ通知設定。

    @return     処理結果。

    @pre
        - アカウントライブラリを初期化している。
*/
nn::Result SetNotificationSettings(const nn::account::Uid& uid, const nn::settings::system::AccountNotificationSettings& settings) NN_NOEXCEPT;

/*!
    @}
*/

}}
