﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/json/friends_Json.h>
#include <nn/friends/detail/service/json/friends_JsonEventHandler.h>
#include <nn/friends/detail/service/json/friends_JsonInputStream.h>
#include <nn/friends/detail/service/util/friends_Cancelable.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace json {

/*!
    @brief      JSON データをパースします。

    @param[in]  handler     イベントハンドラ。
    @param[in]  stream      入力ストリーム。
    @param[in]  cancelable  キャンセル可能オブジェクト。

    @return     処理結果。
*/
nn::Result Parse(JsonEventHandler& handler, JsonInputStream& stream,
    const detail::service::util::Cancelable& cancelable) NN_NOEXCEPT;

}}}}}
