﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/ipc/friends_IServiceCreator.sfdl.h>
#include <nn/friends/detail/ipc/friends_ServiceConfig.h>
#include <nn/friends/detail/service/friends_Capability.h>

namespace nn { namespace friends { namespace detail { namespace service {

/*!
    @brief      サービス生成器です。
*/
class ServiceCreator
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  serviceName サービス名。
        @param[in]  capability  ケイパビリティ。
    */
    ServiceCreator(const char* serviceName, const Capability& capability) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~ServiceCreator() NN_NOEXCEPT;

public:
    // IServiceCreator
    nn::Result CreateFriendService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::IFriendService>> outService) NN_NOEXCEPT;
    nn::Result CreateNotificationService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::INotificationService>> outService, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result CreateDaemonSuspendSessionService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::IDaemonSuspendSessionService>> outService) NN_NOEXCEPT;

private:
    //
    const char* m_ServiceName;
    //
    Capability m_Capability;
};

}}}}
