﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/friends_Task.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンド申請リストを取得するタスクです。
*/
class GetFriendRequestListTask : public Task
{
public:
    /*!
        @brief      コンストラクタです。
    */
    GetFriendRequestListTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[out] outCount    取得した数。
        @param[out] outRequests フレンド申請リスト。
        @param[in]  offset      オフセット。
        @param[in]  count       フレンド申請リストの要素数。
        @param[in]  listType    フレンド申請リスト種別。

        @return     処理結果。
    */
    nn::Result SetParameter(int* outCount, FriendRequestImpl* outRequests,
        int offset, int count, RequestListType listType) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    //
    int* m_OutCount;
    FriendRequestImpl* m_OutRequests;
    //
    int m_Offset;
    int m_Count;
    RequestListType m_ListType;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepGetFacedFriendRequestList() NN_NOEXCEPT;
    nn::Result StepGetSentFriendRequestList() NN_NOEXCEPT;
    nn::Result StepGetReceivedFriendRequestList() NN_NOEXCEPT;
};

}}}}}
