﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンド候補取得用 SNS アカウントの紐付け状態のハンドラです。
*/
class SnsAccountLinkageHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      フレンド候補取得用 SNS アカウントの紐付け状態のパース結果です。
    */
    struct SnsAccountLinkageParseBits
    {
        Bit64 isFacebookLinked : 1;
        Bit64 isTwitterLinked : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    SnsAccountLinkageHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outLinkage  フレンド候補取得用 SNS アカウントの紐付け状態。

        @pre
            - outLinkage != nullptr
    */
    void Initialize(SnsAccountLinkage* outLinkage) NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    SnsAccountLinkage* m_OutLinkage;
    SnsAccountLinkageParseBits m_Bits;
};

}}}}}
