﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      自分と相手ユーザー間の関係情報のハンドラです。
*/
class RelationshipHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      自分と相手ユーザー間の関係情報のパース結果です。
    */
    struct RelationshipParseBits
    {
        Bit64 isFriend : 1;
        Bit64 isFriendOfFriend : 1;
        Bit64 isBlocked : 1;
        Bit64 isRequestPending : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    RelationshipHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outRelationship 自分と相手ユーザー間の関係。

        @pre
            - outRelationship != nullptr
    */
    void Initialize(Relationship* outRelationship) NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnBoolean(const detail::service::json::JsonPath& jsonPath, bool value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    Relationship* m_OutRelationship;
    RelationshipParseBits m_Bits;
};

}}}}}
