﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      プロフィールリソースリストのハンドラです。
*/
class ProfileResourceListHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      プロフィールリソースのパース結果です。
    */
    struct ProfileResourceParseBits
    {
        Bit64 accountId : 1;
        Bit64 nickname : 1;
        Bit64 profileImageUrl : 1;
        Bit64 playLog : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    ProfileResourceListHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outProfiles プロフィールリスト。
        @param[in]  accountIds  任意のユーザーのネットワークサービスアカウント ID リスト。
        @param[in]  count       プロフィールリストの要素数。

        @pre
            - outProfiles != nullptr
            - accountIds != nullptr
            - count > 0
    */
    void Initialize(ProfileImpl* outProfiles,
        const nn::account::NetworkServiceAccountId* accountIds, int count) NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outProfiles プロフィールリスト。
        @param[in]  accountIds  任意のユーザーのネットワークサービスアカウント ID リスト。
        @param[in]  count       プロフィールリストの要素数。

        @pre
            - outProfiles != nullptr
            - accountIds != nullptr
            - count > 0
    */
    void Initialize(ProfileExtraImpl* outProfiles,
        const nn::account::NetworkServiceAccountId* accountIds, int count) NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outProfile  プロフィール。

        @pre
            - outProfile != nullptr
    */
    void Initialize(ProfileExtraImpl* outProfile) NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    ProfileImpl* m_OutProfiles;
    ProfileExtraImpl* m_OutProfileExtras;
    const nn::account::NetworkServiceAccountId* m_AccountIds;
    int m_Count;
    //
    ProfileExtraImpl m_Profile;
    ProfileResourceParseBits m_Bits;

private:
    //
    bool ParsePlayLog(const char* json, size_t length) NN_NOEXCEPT;
};

}}}}}
