﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンドリソースリストのハンドラです。
*/
class FriendResourceListHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      フレンドリソースのパース結果です。
    */
    struct FriendResourceParseBits
    {
        Bit64 accountId : 1;
        Bit64 nickname : 1;
        Bit64 profileImageUrl : 1;
        Bit64 playLog : 1;
        Bit64 lastPlayRecordAppId : 1;
        Bit64 lastPlayRecordPresenceGroupId : 1;
        Bit64 lastPlayRecordName : 1;
        Bit64 lastPlayRecordNameLanguage : 1;
        Bit64 lastPlayRecordMyName : 1;
        Bit64 lastPlayRecordMyNameLanguage : 1;
        Bit64 presenceStatus : 1;
        Bit64 presenceAppId : 1;
        Bit64 presencePresenceGroupId : 1;
        Bit64 presenceLastUpdateTime : 1;
        Bit64 presenceAppField : 1;
        Bit64 presenceLogoutTime : 1;
        Bit64 isFavorite : 1;
        Bit64 isConfirmed : 1;
        Bit64 isOnlineNotification : 1;
        Bit64 requestType : 1;
        Bit64 requestRouteAppId : 1;
        Bit64 requestRoutePresenceGroupId : 1;
        Bit64 requestRouteCatalogId : 1;
        Bit64 requestRouteMiiName : 1;
        Bit64 requestRouteMiiImageUrlParam : 1;
        Bit64 requestRouteName : 1;
        Bit64 requestRouteNameLanguage : 1;
        Bit64 requestRouteTime : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    FriendResourceListHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[in]  buffer  バッファ。
        @param[in]  size    バッファサイズ。

        @return     処理結果。

        @pre
            - buffer != nullptr
            - size >= sizeof (FriendResource) * FriendCountMax
    */
    nn::Result Initialize(void* buffer, size_t size) NN_NOEXCEPT;

    /*!
        @brief      フレンドリソースリストを取得します。

        @return     フレンドリソースリスト。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    const FriendResource* GetResourceList() const NN_NOEXCEPT;

    /*!
        @brief      フレンドリソースリストの要素数を取得します。

        @return     フレンドリソースリストの要素数。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    int GetResourceCount() const NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnKey(const detail::service::json::JsonPath& jsonPath, const char* key) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnBoolean(const detail::service::json::JsonPath& jsonPath, bool value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    FriendResource* m_Resources;
    int m_Count;
    //
    FriendResourceParseBits m_Bits;

private:
    //
    bool ParsePlayLog(const char* json, size_t length) NN_NOEXCEPT;
    //
    bool ParseFriendPresenceAppField(const char* json, size_t length) NN_NOEXCEPT;
};

}}}}}
