﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンド申請リソース件数のハンドラです。
*/
class FriendRequestResourceCountHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      フレンド申請リソースのパース結果です。
    */
    struct FriendRequestResourceParseBits
    {
        Bit64 read : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    FriendRequestResourceCountHandler() NN_NOEXCEPT;

    /*!
        @brief      未読のフレンド申請件数を取得します。

        @return     未読のフレンド申請件数。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    int GetUnreadCount() const NN_NOEXCEPT;

    /*!
        @brief      既読のフレンド申請件数を取得します。

        @return     既読のフレンド申請件数。

        @details
                    本関数は、パース処理が成功した後に呼び出してください。
    */
    int GetReadCount() const NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnBoolean(const detail::service::json::JsonPath& jsonPath, bool value) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    int m_Count;
    int m_ReadCount;
    //
    FriendRequestResourceParseBits m_Bits;
};

}}}}}
