﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      オーバーレイ通知の送信モジュールです。
*/
class OverlayNotificationSender
{
public:
    /*!
        @brief      フレンドリストのサマリー情報を送信します。

        @param[in]  uid                         ユーザーアカウント。
        @param[in]  onlineFriendCount           オンラインフレンド人数。
        @param[in]  unreadFriendRequestCount    未読フレンド申請件数。
        @param[in]  readFriendRequestCount      既読フレンド申請件数。
    */
    static void SendListSummaryMessage(const nn::account::Uid& uid, int32_t onlineFriendCount,
        int32_t unreadFriendRequestCount, int32_t readFriendRequestCount) NN_NOEXCEPT;

    /*!
        @brief      フレンドオンライン通知を送信します。

        @param[in]  uid                             ユーザーアカウント。
        @param[in]  friendAccountId                 フレンドのネットワークサービスアカウント ID。
        @param[in]  elapsedSecondsFromLastUpdate    前回のフレンドプレゼンス更新時刻からの経過時間。
    */
    static void SendFriendOnlineMessage(const nn::account::Uid& uid,
        nn::account::NetworkServiceAccountId friendAccountId, int32_t elapsedSecondsFromLastUpdate) NN_NOEXCEPT;

    /*!
        @brief      フレンド申請受信通知を送信します。

        @param[in]  uid ユーザーアカウント。
    */
    static void SendFriendRequestReceivedMessage(const nn::account::Uid& uid) NN_NOEXCEPT;
};

}}}}}
