﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/ipc/friends_IpcService.h>
#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>

namespace nn { namespace friends { namespace detail {

/*!
    @brief      シムライブラリのグローバルインスタンスです。

    @details
                シムライブラリのファイル間共通データを管理します。
*/
class ShimLibraryGlobal
{
private:
    /*!
        @brief      コンストラクタです。
    */
    ShimLibraryGlobal() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static ShimLibraryGlobal& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(ShimLibraryGlobal, s_Instance);
        return s_Instance;
    }

public:
    /*!
        @brief      インスタンスを初期化します。
    */
    void Initialize() NN_NOEXCEPT;

    /*!
        @brief      API 呼び出し用のセッションを取得します。

        @return     セッション。
    */
    detail::ipc::IFriendService* GetSyncSession() NN_NOEXCEPT;

    /*!
        @brief      非同期 API 呼び出し用のセッションを作成します。

        @param[out] outSession  セッション。

        @return     処理結果。
    */
    nn::Result CreateAsyncSession(detail::ipc::IFriendService** outSession) NN_NOEXCEPT;

    /*!
        @brief      通知サービスオブジェクトを作成します。

        @param[out] outService  NotificationService。
        @param[in]  uid         ユーザーアカウント。

        @return     処理結果。
    */
    nn::Result CreateNotificationService(detail::ipc::INotificationService** outService, const nn::account::Uid& uid) NN_NOEXCEPT;

    /*!
        @brief      自律動作一時停止用セッション管理サービスオブジェクトを作成します。

        @param[out] outService  DaemonSuspendSessionService。

        @return     処理結果。
    */
    nn::Result CreateDaemonSuspendSessionService(detail::ipc::IDaemonSuspendSessionService** outService) NN_NOEXCEPT;

private:
    //
    nn::os::SdkMutex m_Mutex;
    //
    detail::ipc::IFriendService* m_Session;

private:
    //
    void CreateIpcSession() NN_NOEXCEPT;
};

}}}
