﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/fatal/fatal_Result.h>
#include <nn/fatalsrv/fatalsrv_IService.h>
#include <nn/fatalsrv/fatalsrv_FatalContext.h>
#include <nn/fatalsrv/fatalsrv_FatalEventManager.h>
#include <nn/fatalsrv/fatalsrv_CpuContext.h>

#include <nn/os/os_Event.h>

namespace nn { namespace fatalsrv { // NOLINT(whitespace/braces)

    class Service
    {
    public:
        struct Context
        {
            fatalsrv::FatalContext fatalContext;
            fatalsrv::CpuContext cpuContext;
        };

        Service() NN_NOEXCEPT;

        // IService
        nn::Result ThrowFatal(nn::fatalsrv::FatalContext context, nn::Bit64 id) NN_NOEXCEPT;
        nn::Result ThrowFatalWithPolicy(nn::fatalsrv::FatalContext context, nn::Bit64 id, nn::fatal::FatalPolicy policy) NN_NOEXCEPT;
        nn::Result ThrowFatalWithCpuContext(nn::fatalsrv::FatalContext context, nn::Bit64 id, nn::fatal::FatalPolicy policy, const nn::fatalsrv::CpuContext& cpuContext) NN_NOEXCEPT;

        // IPrivateService
        nn::Result GetFatalEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    private:
        void SaveContext(const fatalsrv::FatalContext& fatalContext, const fatalsrv::CpuContext& cpuContext) NN_NOEXCEPT
        {
            m_Context.fatalContext = fatalContext;
            m_Context.cpuContext = cpuContext;
        }

        const Context& GetContext() NN_NOEXCEPT
        {
            return m_Context;
        }

        Result CheckAndUpdateAlreadyThrownFlag() NN_NOEXCEPT
        {
            NN_RESULT_THROW_UNLESS(!m_AlreadyThrown, fatal::ResultAlreadyFatalThrown());
            m_AlreadyThrown = true;
            NN_RESULT_SUCCESS;
        }

        bool m_AlreadyThrown;

        FatalEventManager m_FatalEventManager;
        Context m_Context;
        os::Event m_ErrorReportWrittenEvent;
        os::Event m_BatteryCheckedEvent;
    };

}} // namespace nn::fatalsrv
