﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace fatal {
    /**
    * @brief    Fatal エラーが発生した場合のシステムの挙動を示す列挙体です。
    */
    enum FatalPolicy
    {
        FatalPolicy_Default = 0,            //!<    デフォルトの挙動です。Fatal 画面の表示、コアの停止、エラーレポートの作成、サウンドの停止、クロックの減少を行います。
        FatalPolicy_OnlyErrorReport = 1,    //!<    エラーレポートの作成だけを行います。
        FatalPolicy_WithoutErrorReport = 2, //!<    エラーレポートを記録せずに Fatal 画面へ遷移します。
    };
}} // namespace nn::fatal
