﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ファン制御ライブラリ実装部の制御機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace fan {
namespace impl {

//! @name ドライバ全体を対象とする操作
//! @{

/**
 * @brief ファンの回転数の更新のために経過時間を通知します。
 *
 * @pre
 *  ライブラリは初期化済の状態である必要があります。@n
 *
 * @details
 *  ファンの回転数の更新のために経過時間を通知します。@n
 *  通知された経過時間分、ファンの実際の回転速度が
 *  @ref nn::fan::SetRotationSpeedLevel 等で指定された回転速度レベルに向けて変動します。@n
 */
void NotifyElapsedTime(int64_t elapsedTimeUsec) NN_NOEXCEPT;

//! @}
// ~ドライバ全体を対象とする操作

} // impl
} // fan
} // nn
