﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace es {

void SetConfigs() NN_NOEXCEPT;

// 開発用の鍵を使用するか
bool IsDevelopment() NN_NOEXCEPT;

// デバッグ用の API の使用を許可するかどうか
bool IsDebugApiEnabled() NN_NOEXCEPT;

// NX デバイスが製品機か否か
bool IsProdMode() NN_NOEXCEPT;

// デバッグ用のローカル同時利用判定を行うかどうか
bool IsLocalConcurrencyCheckForDebugEnabled() NN_NOEXCEPT;

// デバッグ用の eLicense のチャレンジ検証を行うかどうか
// デバッグ用の設定が有効な場合、チャレンジ値にかかわらず検証が成功します。
bool IsELicenseChallengeVerificationForDebugEnabled() NN_NOEXCEPT;

}} // namespace nn::es
