﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

 /**
 *   @file
 *   @brief  eLicense アーカイブに関するデバッグ用 API
 *           製品ではこのファイルの API は利用しません。
 */

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/crypto/crypto_Sha256Generator.h>
#include "../../../Programs/Eris/Sources/Libraries/es/es_ELicenseArchiveReader.h"

namespace nn { namespace es { namespace debug {

class ELicenseArchiveBuilder
{
public:
    ELicenseArchiveBuilder() NN_NOEXCEPT
    {
        m_Data.header.formatVersion = 0;
        m_Data.header.hashTableOffset = 0x300;                          // 仕様上の固定値
        m_Data.header.payloadBlockUnitSize = Data::Payload::UnitSize;   // 仕様上の固定値
    }

    void SetPayloadAndEncryptRsa2048OaepSha256(const void* payload, size_t payloadSize, ELicenseArchivePayloadDataFormatType payloadType, const void* modulus, size_t modulusSize, const void* publicExponent, size_t publicExponentSize) NN_NOEXCEPT;
    void SignRsa2048Pkcs1Sha256(const void* modulus, size_t modulusSize, const void* privateExponent, size_t privateExponentSize) NN_NOEXCEPT;
    size_t GetSize() const NN_NOEXCEPT;
    size_t Get(void* outBuffer, size_t bufferSize) const NN_NOEXCEPT;

private:
    struct Data
    {
        ELicenseArchiveSignature signature;
        ELicenseArchiveHeader header;

        struct HashTable
        {
            static const size_t HashSize = crypto::Sha256Generator::HashSize;

            std::unique_ptr<Sha256HashValue[]> hashes;
        }hashTable;

        struct Payload
        {
            static const size_t UnitSize = 16 * 1024;

            struct Block
            {
                uint8_t value[UnitSize];
            };

            std::unique_ptr<Block[]> blocks;
        }payload;

    }m_Data {};
};

}}}
