﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn   {
namespace erpt {
namespace srv  {

// To generate key pair:
//    - 'openssl genpkey -algorithm RSA -out private_key.pem -pkeyopt rsa_keygen_bits:2048'
//    - 'openssl rsa -pubout -in private_key.pem -out public_key.pem'
//    - 'openssl rsa -pubin -inform PEM -text -noout < public_key.pem'
//
// To verify operation:
//    - extract 'CipherKey' field from report, store into cipher_key.bin
//    - decrypt aes key: 'openssl pkeyutl -in cipher_key.bin -decrypt -inkey private_key.pem -pkeyopt rsa_padding_mode:oaep -pkeyopt rsa_oaep_md:sha256 -out aes_key.bin'
//    - extract encrypted data from report, skip 16 byte header, store into field_enc.bin
//    - decrypt data: 'openssl enc -d -aes-128-ctr -in field_enc.bin -out field_dec.bin -K B53D4D47A9057D766317B87F0317FAC9 -iv 881A821CC5FB4BF18FF1B0898CFCBD4A'
//      16 bytes following -K are the hex representation of bytes 0-15 from aes_key.bin, 16 bytes following -iv are the hex
//      representation of bytes 16-31 from aes_key.bin

/* Develop private_key.pem
-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCufWzQwxNhAZ0b
VaDl9D1WfcoOSfuCCAYztjezSj9XOQWEGD2C2I+88+Fm7tKAQ/int15bXPmdf+ls
k4plu9HdVv98nSRmCYQhLH8KuDFCKebTIHahH35ZW3z2xgLbyRu5JJmtD3sNjn4B
/pXOm7UJxfWlaoL2V/gGcq5zcdEJK+KEDWY5tiGLNeTfkDbhP8Cf+IUD1sq7GmIt
5QP2RwBumFocUZRH9oMMJb2+vWo1wKtl+AH0wyqjvNfZ9yqYJ+E/ms/fsTCCpKp4
ysi4NPqndSPJnBFofg+Aj5Cm3itHW5RvuWdMwa5Qj9jj0fKSVEwlAlsxZV5BgTT0
8TTnZHrBAgMBAAECggEBAKf22H6EqezhTsh3PvDckQbnA0+J6+8Zpk61Ax01RY/C
tgqYAu4nZQXwhXM+Raduxrc7jjrIXwg7jwkTZU/U4on8KudbpSQL2QLOAGTjNZeJ
Gkb1ovwqgselh79MkIfdKTCpiLzMgBlmpulolfBSdoy34GShCPv1Zi1ey4sZbq0x
2A/5/hPi/jfOmVhh+xMnX/nDRyBaj9Uhkqs5KcW9tSH/ONpVhiVAjoGxWzOJYx/z
Df0xm3xXVSxe3tqlCA+L2pFogCzAlVF5homCPT9poOudq2WwjKrjK20ow/nS25Ao
92aobGlr7Sr3/vJx+bcoYgSFGUX8P//uvTKXp2cUbqECgYEA3IRFY2luXOOXaX55
2ZBjKDm+b1MOCpc0xffPBQrof989hx37/U7Z+Jy5fFHhN4WaJvSC3sfg13xcKKef
Cd/bukMfeh+IYk9tP3RlQA+7+6k3iA85TkVN9YVBuGOcGH5t43KPvTN6tkD4rDKG
6Y/gJztuKjTD1VT18LhKVBYHK20CgYEAypEtcX+xc/zO9B2XEZkVVDquEtn7VhMf
rikRlbWSKAhrFcPNB5HsSu1h3ROZWkvgskwLfWqR24r1q9KJVOk0SoM3uy2Za+Zl
YNwnoXhG3vJMvYiN6b9B5f1lr0h7OmLozq/BA3zqMZUyrPiDuWE9K57gJA3GEp4i
HL9lSRRzhCUCgYA8JggXOabUx2+BYvIxmeSyEC4Vh34I/X1zkkhxg6wvVOEffdpC
GcPywC0H7/2Se2q0vXUE91go7s7kd/Q1aU4x3CU11mwJBMkzybfkZWZNGrb+8cgb
xWOiWJq4hNMLC1FF/PWgEe6iz84EijOqeYgWq2s9L+9KvUXoRxxfGzMRcQKBgQC1
l6YUbHOpVgY1A13NUd20D5LDpZRSGny5BWoVOpuWtc1ByrC/y4n3tYyYwpwkPYdm
bxORz/qHxK/t46RncVQGRFGuw/cYqodRaKtCbm+iJ7ax5nvKA0HRKvOASkrmEYtA
1oACX3YXEvhF5dc4VbqfoyKuT4a0Y/ySpuXmuKXB3QKBgQCPz14QOpw6JCkKwyIP
nfZ2ePRxMlBNCEbnQhinOjWKPzNsdKBppSgx5aQsR+bKB1EpZyjYmXczF9M7WqT4
ZP75z6JBqAs/X029Ujj/Fz/oaAamLnKoDiCptI3kMq+It+cSkJ53SFgEl2Iw9Fpq
fqhETBH9Z++aggwqZvQtfiNJRg==
-----END PRIVATE KEY-----
*/

const uint8_t PublicKeyModulusForDev[] =
{
    0x00, 0xae, 0x7d, 0x6c, 0xd0, 0xc3, 0x13, 0x61, 0x01, 0x9d, 0x1b, 0x55, 0xa0, 0xe5, 0xf4,
    0x3d, 0x56, 0x7d, 0xca, 0x0e, 0x49, 0xfb, 0x82, 0x08, 0x06, 0x33, 0xb6, 0x37, 0xb3, 0x4a,
    0x3f, 0x57, 0x39, 0x05, 0x84, 0x18, 0x3d, 0x82, 0xd8, 0x8f, 0xbc, 0xf3, 0xe1, 0x66, 0xee,
    0xd2, 0x80, 0x43, 0xf8, 0xa7, 0xb7, 0x5e, 0x5b, 0x5c, 0xf9, 0x9d, 0x7f, 0xe9, 0x6c, 0x93,
    0x8a, 0x65, 0xbb, 0xd1, 0xdd, 0x56, 0xff, 0x7c, 0x9d, 0x24, 0x66, 0x09, 0x84, 0x21, 0x2c,
    0x7f, 0x0a, 0xb8, 0x31, 0x42, 0x29, 0xe6, 0xd3, 0x20, 0x76, 0xa1, 0x1f, 0x7e, 0x59, 0x5b,
    0x7c, 0xf6, 0xc6, 0x02, 0xdb, 0xc9, 0x1b, 0xb9, 0x24, 0x99, 0xad, 0x0f, 0x7b, 0x0d, 0x8e,
    0x7e, 0x01, 0xfe, 0x95, 0xce, 0x9b, 0xb5, 0x09, 0xc5, 0xf5, 0xa5, 0x6a, 0x82, 0xf6, 0x57,
    0xf8, 0x06, 0x72, 0xae, 0x73, 0x71, 0xd1, 0x09, 0x2b, 0xe2, 0x84, 0x0d, 0x66, 0x39, 0xb6,
    0x21, 0x8b, 0x35, 0xe4, 0xdf, 0x90, 0x36, 0xe1, 0x3f, 0xc0, 0x9f, 0xf8, 0x85, 0x03, 0xd6,
    0xca, 0xbb, 0x1a, 0x62, 0x2d, 0xe5, 0x03, 0xf6, 0x47, 0x00, 0x6e, 0x98, 0x5a, 0x1c, 0x51,
    0x94, 0x47, 0xf6, 0x83, 0x0c, 0x25, 0xbd, 0xbe, 0xbd, 0x6a, 0x35, 0xc0, 0xab, 0x65, 0xf8,
    0x01, 0xf4, 0xc3, 0x2a, 0xa3, 0xbc, 0xd7, 0xd9, 0xf7, 0x2a, 0x98, 0x27, 0xe1, 0x3f, 0x9a,
    0xcf, 0xdf, 0xb1, 0x30, 0x82, 0xa4, 0xaa, 0x78, 0xca, 0xc8, 0xb8, 0x34, 0xfa, 0xa7, 0x75,
    0x23, 0xc9, 0x9c, 0x11, 0x68, 0x7e, 0x0f, 0x80, 0x8f, 0x90, 0xa6, 0xde, 0x2b, 0x47, 0x5b,
    0x94, 0x6f, 0xb9, 0x67, 0x4c, 0xc1, 0xae, 0x50, 0x8f, 0xd8, 0xe3, 0xd1, 0xf2, 0x92, 0x54,
    0x4c, 0x25, 0x02, 0x5b, 0x31, 0x65, 0x5e, 0x41, 0x81, 0x34, 0xf4, 0xf1, 0x34, 0xe7, 0x64,
    0x7a, 0xc1
};

const uint8_t PublicKeyExponentForDev[] =
{
    0x01, 0x00, 0x01
};

const uint8_t PublicKeyModulusForProd[] =
{
    0x00, 0xab, 0xb6, 0x6c, 0x43, 0x86, 0xdf, 0x52, 0x5f, 0xb9, 0xd3, 0x61, 0xeb, 0xfb, 0x16,
    0x2b, 0x44, 0xe1, 0x1f, 0xdd, 0x81, 0xfa, 0x20, 0x48, 0x7b, 0xdb, 0x17, 0x9f, 0x9a, 0x92,
    0x1e, 0x0a, 0x80, 0xd1, 0x1a, 0x4f, 0xd7, 0x49, 0xfe, 0xba, 0x65, 0xe4, 0x61, 0x08, 0x26,
    0x43, 0x7b, 0x4a, 0x16, 0x59, 0x60, 0xd1, 0xe0, 0x42, 0x0a, 0x26, 0x54, 0xc4, 0xc7, 0x2a,
    0xe3, 0x17, 0x1f, 0x8e, 0x35, 0x79, 0xc0, 0x1b, 0xa1, 0xf8, 0x6f, 0x5c, 0xdc, 0x05, 0x2d,
    0x90, 0x75, 0xd5, 0x98, 0x7e, 0x5a, 0x07, 0x3f, 0x4e, 0x78, 0xf1, 0x69, 0x2f, 0xe9, 0x2e,
    0x50, 0x01, 0x9f, 0xce, 0x35, 0xc8, 0x4d, 0x65, 0x23, 0xa8, 0x9f, 0xc3, 0x3c, 0x4a, 0xf2,
    0x29, 0x4d, 0x10, 0x03, 0x1c, 0xb4, 0x0e, 0x64, 0xb6, 0xdd, 0xb2, 0x74, 0xe3, 0x32, 0x84,
    0x25, 0x99, 0xea, 0xe1, 0x6c, 0x78, 0x24, 0xf2, 0xb0, 0xd2, 0x2c, 0xa5, 0x1a, 0x70, 0xa6,
    0x49, 0x08, 0x73, 0x8a, 0x74, 0x3a, 0x12, 0x0e, 0x1b, 0x68, 0xd1, 0x6a, 0x6c, 0x3f, 0x2c,
    0x2c, 0x53, 0xd5, 0xce, 0x5a, 0x07, 0xa2, 0xb9, 0x2e, 0x0a, 0x77, 0x51, 0x4b, 0xd2, 0x8e,
    0x4f, 0xa3, 0xa8, 0x56, 0x99, 0x6f, 0x63, 0xbc, 0x23, 0x04, 0x6e, 0x71, 0x57, 0x7c, 0xfd,
    0x84, 0xa7, 0xf8, 0x8d, 0x7f, 0xd6, 0xa0, 0x6e, 0x92, 0xbc, 0xcc, 0x28, 0x82, 0x60, 0xe9,
    0x78, 0xc1, 0x31, 0x82, 0x4f, 0xf8, 0xc5, 0xdb, 0xb6, 0x6b, 0xf9, 0x62, 0x95, 0xd3, 0xc8,
    0x63, 0x59, 0x53, 0x3f, 0x82, 0xeb, 0x06, 0xa7, 0xb8, 0x55, 0xec, 0x9e, 0x33, 0x04, 0xcf,
    0x5e, 0x42, 0x32, 0x09, 0x26, 0xff, 0xb4, 0x5e, 0xbd, 0xd7, 0xa8, 0x6b, 0x2c, 0xf5, 0x68,
    0x86, 0xcd, 0x8a, 0x13, 0xf3, 0x1c, 0x5f, 0xe6, 0x4f, 0xfc, 0xd1, 0x07, 0x28, 0x5c, 0x2d,
    0xa7, 0xf7
};

const uint8_t PublicKeyExponentForProd[] =
{
    0x01, 0x00, 0x01
};

}}}

