﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      eclct モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_ECLCT_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_ECLCT_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_ECLCT_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_ECLCT_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_ECLCT_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_ECLCT_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eclct, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_ECLCT_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Trace, 0, format, args)
#define NN_DETAIL_ECLCT_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Trace, 1, format, args)
#define NN_DETAIL_ECLCT_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Trace, 2, format, args)
#define NN_DETAIL_ECLCT_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Trace, 3, format, args)

#define NN_DETAIL_ECLCT_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Info, 0, format, args)
#define NN_DETAIL_ECLCT_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Info, 1, format, args)
#define NN_DETAIL_ECLCT_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Info, 2, format, args)
#define NN_DETAIL_ECLCT_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Info, 3, format, args)

#define NN_DETAIL_ECLCT_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Warn, 0, format, args)
#define NN_DETAIL_ECLCT_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Warn, 1, format, args)
#define NN_DETAIL_ECLCT_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Warn, 2, format, args)
#define NN_DETAIL_ECLCT_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Warn, 3, format, args)

#define NN_DETAIL_ECLCT_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Error, 0, format, args)
#define NN_DETAIL_ECLCT_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Error, 1, format, args)
#define NN_DETAIL_ECLCT_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Error, 2, format, args)
#define NN_DETAIL_ECLCT_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Error, 3, format, args)

#define NN_DETAIL_ECLCT_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Fatal, 0, format, args)
#define NN_DETAIL_ECLCT_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Fatal, 1, format, args)
#define NN_DETAIL_ECLCT_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Fatal, 2, format, args)
#define NN_DETAIL_ECLCT_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eclct, Fatal, 3, format, args)

#define NN_DETAIL_ECLCT_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Trace, 0, text, length)
#define NN_DETAIL_ECLCT_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Trace, 1, text, length)
#define NN_DETAIL_ECLCT_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Trace, 2, text, length)
#define NN_DETAIL_ECLCT_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Trace, 3, text, length)

#define NN_DETAIL_ECLCT_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Info, 0, text, length)
#define NN_DETAIL_ECLCT_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Info, 1, text, length)
#define NN_DETAIL_ECLCT_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Info, 2, text, length)
#define NN_DETAIL_ECLCT_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Info, 3, text, length)

#define NN_DETAIL_ECLCT_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Warn, 0, text, length)
#define NN_DETAIL_ECLCT_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Warn, 1, text, length)
#define NN_DETAIL_ECLCT_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Warn, 2, text, length)
#define NN_DETAIL_ECLCT_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Warn, 3, text, length)

#define NN_DETAIL_ECLCT_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Error, 0, text, length)
#define NN_DETAIL_ECLCT_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Error, 1, text, length)
#define NN_DETAIL_ECLCT_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Error, 2, text, length)
#define NN_DETAIL_ECLCT_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Error, 3, text, length)

#define NN_DETAIL_ECLCT_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Fatal, 0, text, length)
#define NN_DETAIL_ECLCT_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Fatal, 1, text, length)
#define NN_DETAIL_ECLCT_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Fatal, 2, text, length)
#define NN_DETAIL_ECLCT_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eclct, Fatal, 3, text, length)
