﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Eコマース処理を行うAPIに必要な型や定数などの内部向け定義
 */

#pragma once

#include <nn/nn_StaticAssert.h>
#include <nn/ec/ec_ShopTypesForSystem.h>

namespace nn { namespace ec { namespace detail {

enum LaunchMode
{
    LaunchMode_Mini = 0,
    LaunchMode_Full,
    LaunchMode_TotalCount
};

static const char* LaunchModeStrings[] = {
    "mini",
    "full"
};
NN_STATIC_ASSERT(std::extent<decltype(LaunchModeStrings)>::value == LaunchMode_TotalCount);

// 処理成功時のコールバックURL(キャンセルやエラーを含まず)
static const char ShopSuccessLastUrl[] = "eshop://success"; // (const char[] なのでNULL文字が含まれる)
static const size_t ShopSuccessLastUrlSize = sizeof(ShopSuccessLastUrl); // NULL文字分含むバイトサイズ

inline const char* LaunchModeToString(LaunchMode mode) NN_NOEXCEPT
{
    return LaunchModeStrings[static_cast<int>(mode)];
}

}}}
